<?php
// includes/hooks/validate_rootpw.php
add_hook('ClientAreaFooterOutput', 1, function($vars) {
    if (!isset($_GET['a']) || $_GET['a'] !== 'confproduct') {
        return;
    }
    return <<<HTML
<script>
document.addEventListener('DOMContentLoaded', function() {
    var pwInput = document.getElementById('inputRootpw');
    if (!pwInput) return;
    // 创建/获取错误显示元素
    var errId = 'rootpwError';
    var errEl = document.getElementById(errId);
    if (!errEl) {
        errEl = document.createElement('div');
        errEl.id = errId;
        errEl.className = 'help-block text-danger';
        pwInput.parentNode.appendChild(errEl);
    }
    function validate(pw) {
        // 至少1个小写、1个大写、1个数字、1个特殊符号，且最少8位
        return /^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[^A-Za-z0-9]).{8,}$/.test(pw || '');
    }
    function showError(msg) {
        errEl.textContent = msg;
        pwInput.classList.add('is-invalid');
    }
    function clearError() {
        errEl.textContent = '';
        pwInput.classList.remove('is-invalid');
    }
    // 实时校验（用户输入时）
    pwInput.addEventListener('input', function() {
        if (pwInput.value === '') {
            clearError();
            return;
        }
        if (!validate(pwInput.value)) {
            showError('密碼強度不足：至少8位，包含大寫、小寫、數字和特殊符號。');
        } else {
            clearError();
        }
    });
    // 在表单提交时拦截
    // 优先找到提交按钮并取其最近的 form；若找不到则 fallback 到页面第一个 form
    var submitBtn = document.getElementById('btnCompleteProductConfig');
    var form = submitBtn && submitBtn.closest ? submitBtn.closest('form') : null;
    if (!form) form = document.querySelector('form');
    if (!form) return;
    form.addEventListener('submit', function(e) {
        var v = pwInput.value || '';
        if (!validate(v)) {
            e.preventDefault();
            e.stopPropagation();
            showError('密碼強度不足：至少8位，包含大寫、小寫、數字和特殊符號。');
            // 将焦点移到密码框，帮助用户修正
            pwInput.focus();
            return false;
        }
        return true;
    }, true);
});
</script>
HTML;
});